-- File generated with hex2prom.exe  DO NOT EDIT THIS FILE!
-- Copyright (C) 2017  Dr. Uwe Meyer-Baese.
-- ==================================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =====================================================
ENTITY rom4096x18 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0)); -- Program memory data
END ENTITY rom4096x18;
-- =====================================================
ARCHITECTURE fpga OF rom4096x18 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(17 DOWNTO 0);
CONSTANT prom : MEMP := (
"000001000100000101", "101111000100000001", "000001000100000110", 
"000001001000000010", "101110000100100000", "001011001100000001", 
"001010001100100000", "100010000000000000", OTHERS => "100010000000000000");

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
